<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use App\Models\Settings;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\DB;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Rules\MatchOldPassword;

class AdminController extends Controller
{
    use ValidatesRequests;

    public function index()
    {
        $data = User::select(DB::raw('COUNT(*) as count'), DB::raw('DAYNAME(created_at) as day_name'), DB::raw('DAY(created_at) as day'))
            ->where('created_at', '>', Carbon::today()->subDays(6))
            ->groupBy('day_name', 'day')
            ->orderBy('day')
            ->get();

        $array[] = ['Name', 'Number'];
        foreach ($data as $key => $value) {
            $array[++$key] = [$value->day_name, $value->count];
        }

        return view('backend.index')->with('users', json_encode($array));
    }

    public function profile()
    {
        $profile = Auth::user();
        return view('backend.users.profile')->with('profile', $profile);
    }

    public function profileUpdate(Request $request, $id)
    {
        $user = User::findOrFail($id);
        $data = $request->all();
        $status = $user->fill($data)->save();

        if ($status) {
            $request->session()->flash('success', 'Successfully updated your profile');
        } else {
            $request->session()->flash('error', 'Please try again!');
        }

        return redirect()->back();
    }

    public function settings()
    {
        $data = Settings::first();
        return view('backend.setting')->with('data', $data);
    }

    public function settingsUpdate(Request $request)
    {
        $this->validate($request, [
            'short_des' => 'required|string',
            'description' => 'required|string',
            'photo' => 'required',
            'logo' => 'required',
            'address' => 'required|string',
            'email' => 'required|email',
            'phone' => 'required|string',
        ]);

        $data = $request->all();
        $settings = Settings::first();
        $status = $settings->fill($data)->save();

        if ($status) {
            $request->session()->flash('success', 'Setting successfully updated');
        } else {
            $request->session()->flash('error', 'Please try again');
        }

        return redirect()->route('admin');
    }

    public function changePassword()
    {
        return view('backend.layouts.changePassword');
    }

    public function changPasswordStore(Request $request)
    {
        $request->validate([
            'current_password' => ['required', new MatchOldPassword],
            'new_password' => ['required'],
            'new_confirm_password' => ['same:new_password'],
        ]);

        User::find(Auth::user()->id)->update(['password' => Hash::make($request->new_password)]);

        return redirect()->route('admin')->with('success', 'Password successfully changed');
    }

    public function userPieChart(Request $request)
    {
        $data = User::select(DB::raw('COUNT(*) as count'), DB::raw('DAYNAME(created_at) as day_name'), DB::raw('DAY(created_at) as day'))
            ->where('created_at', '>', Carbon::today()->subDays(6))
            ->groupBy('day_name', 'day')
            ->orderBy('day')
            ->get();

        $array[] = ['Name', 'Number'];
        foreach ($data as $key => $value) {
            $array[++$key] = [$value->day_name, $value->count];
        }

        return view('backend.index')->with('course', json_encode($array));
    }

    public function storageLink()
    {
        if (File::exists(public_path('storage'))) {
            File::delete(public_path('storage'));
        }

        try {
            Artisan::call('storage:link');
            request()->session()->flash('success', 'Successfully storage linked.');
        } catch (\Exception $exception) {
            request()->session()->flash('error', $exception->getMessage());
        }

        return redirect()->back();
    }
}
