<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LibroReclamaciones extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'libro_reclamaciones';
    protected $primaryKey = 'id';

    protected $fillable = [
        'fecha',
        'nombre_y_apellidos',
        'direccion',
        'distrito',
        'documento_tipo',
        'documento_numero',
        'email',
        'telefono',
        'padre_o_madre',
        'producto',
        'servicio',
        'reclamo',
        'queja',
        'detalle',
    ];

    public function respuestas()
    {
        return $this->hasMany(Respuesta::class);
    }
}
