<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Newsletter extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'newsletters';
    protected $primaryKey = 'id';
    protected $fillable = ['email'];

    public static function isSubscribed($email)
    {
        return self::where('email', $email)->exists();
    }

    public static function subscribePending($email)
    {
        return self::create(['email' => $email]);
    }

    public static function lastActionSucceeded()
    {
        // Implementar lógica para verificar si la última acción fue exitosa
        return true;
    }

    public static function getLastError()
    {
        // Implementar lógica para obtener el último error
        return null;
    }
}
