<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PostCategory;

class PostCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        PostCategory::create([
            'title' => 'General',
            'slug' => 'general',
            'description' => 'General category for all posts.',
            'photo' => 'https://example.com/photo.jpg',
            'status' => 'active',

        ]);
        PostCategory::create([
            'title' => 'Technology',
            'slug' => 'technology',
            'description' => 'Category for technology-related posts.',
            'photo' => 'https://example.com/photo.jpg',
            'status' => 'active',
        ]);
        PostCategory::create([
            'title' => 'Health',
            'slug' => 'health',
            'description' => 'Category for health-related posts.',
            'photo' => 'https://example.com/photo.jpg',
            'status' => 'active',
        ]);
        PostCategory::create([
            'title' => 'Lifestyle',
            'slug' => 'lifestyle',
            'description' => 'Category for lifestyle-related posts.',
            'photo' => 'https://example.com/photo.jpg',
            'status' => 'active',
        ]);
    }
}
