<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create roles
        $roleAdmin = Role::create(['name' => 'admin']);
        $roleUser = Role::create(['name' => 'user']);
        $roleSuperAdmin = Role::create(['name' => 'super-admin']);
        $roleModerator = Role::create(['name' => 'moderator']);
        $roleCustomer = Role::create(['name' => 'customer']);
        $roleProvider = Role::create(['name' => 'provider']);

        // Assign permissions to roles
        $permissions = Permission::all();
        $roleAdmin->syncPermissions($permissions);
        $roleUser->syncPermissions($permissions);
        $roleSuperAdmin->syncPermissions($permissions);
        $roleModerator->syncPermissions($permissions);
        $roleCustomer->syncPermissions($permissions);
        $roleProvider->syncPermissions($permissions);
    }
}
