<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Service;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Service::create([
            'name' => 'Web Development',
            'slug' => 'web-development',
            'image' => 'web-development.jpg',
            'resumen' => 'We offer web development services.',
            'description' => 'We provide high-quality web development services to help you build your online presence.',
        ]);
        Service::create([
            'name' => 'Mobile App Development',
            'slug' => 'mobile-app-development',
            'image' => 'mobile-app-development.jpg',
            'resumen' => 'We offer mobile app development services.',
            'description' => 'We create user-friendly mobile applications for both iOS and Android platforms.',
        ]);
        Service::create([
            'name' => 'Digital Marketing',
            'slug' => 'digital-marketing',
            'image' => 'digital-marketing.jpg',
            'resumen' => 'We offer digital marketing services.',
            'description' => 'Our digital marketing services help you reach your target audience effectively.',
        ]);
        Service::create([
            'name' => 'SEO Optimization',
            'slug' => 'seo-optimization',
            'image' => 'seo-optimization.jpg',
            'resumen' => 'We offer SEO optimization services.',
            'description' => 'Our SEO optimization services help improve your website\'s visibility on search engines.',
        ]);
        Service::create([
            'name' => 'Content Writing',
            'slug' => 'content-writing',
            'image' => 'content-writing.jpg',
            'resumen' => 'We offer content writing services.',
            'description' => 'Our content writing services provide high-quality content for your website and marketing materials.',
        ]);
        Service::create([
            'name' => 'Graphic Design',
            'slug' => 'graphic-design',
            'image' => 'graphic-design.jpg',
            'resumen' => 'We offer graphic design services.',
            'description' => 'Our graphic design services help you create visually appealing designs for your brand.',
        ]);
    }
}
