@extends('frontend.layouts.master')
@section('title', 'RASEMCORP || QUIENES SOMOS')
@section('meta-author', 'RASEMCORP')
@section('meta-image', asset('frontend/assets/img/rasemcorp-fav.png'))
@section('meta-url', url()->current())
@section('meta-type', 'website')
@section('meta-robots', 'index, follow')
@section('main-content')

    <!-- Quienes Somos -->
    <main class="main">

        <!-- Hero Section -->
        <section id="hero" class="heroheader section dark-background">
            <div style="position: relative;">
                <div
                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.7); z-index: 1;">
                </div>
                <img src="{{ asset('frontend/assets/img/hero-bg.jpg') }}" alt="" data-aos="fade-in"
                    style="position: relative; z-index: 0;">
            </div>
        </section>
        <!-- /Hero Section -->

        <!-- About Section -->
        <section id="about" class="about section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="row gy-4">
                    <div class="col-lg-6 order-1 order-lg-2">
                        <img src="{{ asset('frontend/assets/img/text-header.png') }}" class="img-fluid" alt="">
                    </div>
                    <div class="col-lg-6 order-2 order-lg-1 content">
                        <h3>¿Quienes somos?</h3>
                        <p class="fst-italic">
                            Somos un grupo empresarial integrado por un equipo de profesionales que gestionamos y
                            desarrollamos nuestras actividades en distintas áreas de acción y líneas de negocio, siempre
                            manteniendo los más altos valores de calidad.
                        </p>
                        <ul>
                            <li><i class="bi bi-check2-all"></i> <span>Nuestra Historia</span></li>
                            @php
                                $date1 = '1998';
                                $date2 = date('Y');
                                $diff = $date2 - $date1;
                            @endphp
                            <p>
                                El grupo surge como empresa familiar, hace {{ $diff }} años, con una visión de
                                aportar al crecimiento
                                y desarrollo de nuestro país y nuestra gente. en 1998, se construye, equipa y gestiona
                                nuestro primer centro de hemodiálisis, en la ciudad de lima, constituyendo al día de hoy
                                como unos de los principales proveedores del servicio de atención ambulatoria para pacientes
                                con enfermedad renal crónica en el Perú.
                            </p>
                            <li><i class="bi bi-check2-all"></i> <span>Nuestro Personal</span></li>
                            <p>
                                Contamos con un grupo humano comprometido y responsable por el logro de los objetivos al
                                asumir nuevos retos en los diferentes proyectos a desarrollar y ejecutar. Damos empleo a más
                                de 250 personas en planilla fija, además del personal rotativo según proyecto a ejecutar.
                            </p>
                        </ul>
                    </div>
                </div>
            </div>

        </section><!-- /About Section -->

        <!-- Clients Section -->
        <section id="clients" class="clients section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="swiper init-swiper">
                    <script type="application/json" class="swiper-config">
                {
                  "loop": true,
                  "speed": 600,
                  "autoplay": {
                    "delay": 5000
                  },
                  "slidesPerView": "auto",
                  "pagination": {
                    "el": ".swiper-pagination",
                    "type": "bullets",
                    "clickable": true
                  },
                  "breakpoints": {
                    "320": {
                      "slidesPerView": 2,
                      "spaceBetween": 40
                    },
                    "480": {
                      "slidesPerView": 3,
                      "spaceBetween": 60
                    },
                    "640": {
                      "slidesPerView": 4,
                      "spaceBetween": 80
                    },
                    "992": {
                      "slidesPerView": 6,
                      "spaceBetween": 120
                    }
                  }
                }
              </script>
                    <div class="swiper-wrapper align-items-center">
                        <div class="swiper-slide">
                            <a href="{{ route('clinical-care') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/clinical-care-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('cedisan') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/cedisan-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('kidney-care') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/kidney-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('hemobalance-care') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/hemobalance-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('jrs-meddev') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/jrs-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('primelab') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/primelab.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('intifarma') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/intifarma-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('pandorafarma') }}"><img
                                    src="{{ asset('frontend/assets/img/salud/pandorafarma-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="{{ route('tsg-trade') }}"><img
                                    src="{{ asset('frontend/assets/img/ingenieria/tsg-logo.png') }}" class="img-fluid"
                                    alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>

            </div>

        </section><!-- /Clients Section -->

        <!-- Features Section -->
        <section id="features" class="features section">

            <div class="container">

                <div class="row gy-4">
                    <!-- Section Title -->
                    <div class="container section-title" data-aos="fade-up">
                        <h2>Quienes Somos</h2>
                        <p>Organigrama</p>
                    </div><!-- End Section Title -->
                    <div class="features-image col-lg-6" data-aos="fade-up" data-aos-delay="100">

                        <img src="{{ asset('frontend/assets/img/organigrama.png') }}" alt="" class="img-fluid"
                            style="width: 100%; height: auto; object-fit: cover;">
                    </div>
                    <div class="col-lg-6">

                        <div class="features-item d-flex ps-0 ps-lg-3 pt-4 pt-lg-0" data-aos="fade-up" data-aos-delay="200">
                            <i class="bi bi-broadcast flex-shrink-0"></i>
                            <div>
                                <h4>Objetivos</h4>
                                <p>La satisfacción y cumplimiento con los requerimientos y necesidades de nuestros clientes,
                                    al prestar nuestros servicios de calidad, manteniendo el control y mejorando nuestros
                                    procesos de la organización basado en una mejora continua.</p>
                            </div>
                        </div><!-- End Features Item-->

                        <div class="features-item d-flex mt-5 ps-0 ps-lg-3" data-aos="fade-up" data-aos-delay="300">
                            <i class="bi bi-broadcast flex-shrink-0"></i>
                            <div>
                                <h4>Mision</h4>
                                <p>Proporcionar a nuestros clientes asesoría, servicios, ingeniería y ejecución de proyectos
                                    de calidad usando la mejor tecnología de diseño, materiales y equipamiento, bajo la
                                    dirección de nuestro personal altamente calificado.</p>
                            </div>
                        </div><!-- End Features Item-->

                        <div class="features-item d-flex mt-5 ps-0 ps-lg-3" data-aos="fade-up" data-aos-delay="400">
                            <i class="bi bi-broadcast flex-shrink-0"></i>
                            <div>
                                <h4>Vision</h4>
                                <p>Posicionarnos en el ámbito privado y estatal a nivel nacional como una de las mejores
                                    empresas y mantenernos a la vanguardia en cuanto a las nuevas tecnologías de la
                                    construcción, gestión de la salud, basándonos en la especialización de la nuestros
                                    personal.</p>
                            </div>
                        </div><!-- End Features Item-->

                    </div>
                </div>

            </div>

        </section><!-- /Features Section -->
    </main>
    <!-- End Quienes Somos -->
@endsection

@push('styles')
@endpush

@push('scripts')
@endpush
