@extends('frontend.layouts.master')
@section('title', 'RASEMCORP || LIBRO DE RECLAMACIONES')
@section('meta-author', 'RASEMCORP')
@section('meta-image', asset('frontend/assets/img/rasemcorp-fav.png'))
@section('meta-url', url()->current())
@section('meta-type', 'website')
@section('meta-robots', 'index, follow')
@section('main-content')

    <main class="main">
        <!-- Hero Section -->
        <section id="hero" class="heroheader section dark-background">
            <div style="position: relative;">
                <div
                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.7); z-index: 1;">
                </div>
                <img src="{{ asset('frontend/assets/img/hero-bg.jpg') }}" alt="" data-aos="fade-in"
                    style="position: relative; z-index: 0;">
            </div>
        </section>
        <!-- /Hero Section -->
        <!-- Libro de reclamaciones -->
        <section id="contact" class="contact section">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 col-12">
                        <div class="about-content">
                            <h3>Libro de <span>Reclamaciones</span></h3>
                            <p>
                            <div class="row">
                                <div class="col-lg-9 mx-auto">
                                    <p class="text-center">Conforme a lo establecido en el código de la Protección y Defensa
                                        del
                                        consumidor contamos con un Libro de Reclamaciones a tu disposición. Ingresa una
                                        queja o
                                        reclamo aquí.</p>
                                    <form class="needs-validation" id="libro_reclamaciones" novalidate
                                        enctype="multipart/form-data" action="{{ route('libro-reclamaciones.submit') }}"
                                        method="post">
                                        @csrf
                                        <div class="row">
                                            <div class="col-lg-4 mb-3">
                                                <label for="fecha">Fecha</label>
                                                <input type="text" class="form-control" name="fecha" id="fecha"
                                                    value="{{ date('Y-m-d') }}" readonly>
                                            </div>
                                            <div class="col-lg-8 mb-3">
                                                <label for="nombre_y_apellidos">Nombre y apellidos</label>
                                                <input type="text" class="form-control" name="nombre_y_apellidos"
                                                    id="nombre_y_apellidos" required>
                                                <div class="invalid-feedback">
                                                    Por favor ingrese su nombre y apellidos.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 mb-3">
                                                <label for="direccion">Dirección completa</label>
                                                <input type="text" class="form-control" name="direccion" id="direccion"
                                                    required>
                                                <div class="invalid-feedback">
                                                    Por favor ingrese su dirección.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 mb-3">
                                                <label for="distrito">Distrito</label>
                                                <input type="text" class="form-control" name="distrito" id="distrito"
                                                    required>
                                                <div class="invalid-feedback">
                                                    Por favor ingrese su distrito.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-6 mb-3">
                                                <label for="documento_tipo">Tipo de documento</label>
                                                <select class="form-control" name="documento_tipo" id="documento_tipo"
                                                    required>
                                                    <option value="">Elegir</option>
                                                    <option value="RUC">(RUC) REGISTRO ÚNICO DE CONTRIBUYENTES</option>
                                                    <option value="DNI">(DNI) DOCUMENTO NACIONAL DE IDENTIDAD</option>
                                                    <option value="CARNET DE EXTRANJERIA">CARNET DE EXTRANJERIA</option>
                                                    <option value="PASAPORTE">PASAPORTE</option>
                                                    <option value="CARNÉ DE SOLICITUD DE REFUGIO">CARNÉ DE SOLICITUD DE
                                                        REFUGIO
                                                    </option>
                                                    <option value="PARTIDA DE NACIMIENTO">PARTIDA DE NACIMIENTO</option>
                                                    <option value="CEDULA DIPLOMATICA DE IDENTIDAD">CEDULA DIPLOMATICA DE
                                                        IDENTIDAD</option>
                                                    <option value="OTROS TIPOS DE DOCUMENTOS">OTROS TIPOS DE DOCUMENTOS
                                                    </option>
                                                </select>
                                                <div class="invalid-feedback">
                                                    Por favor seleccione un tipo de documento.
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-3">
                                                <label for="documento_numero">Documento número</label>
                                                <input type="text" class="form-control" name="documento_numero"
                                                    id="documento_numero" required>
                                                <div class="invalid-feedback">
                                                    Por favor ingrese el número de documento.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-6 mb-3">
                                                <label for="email">Email</label>
                                                <input type="email" class="form-control" name="email" id="email"
                                                    required>
                                                <div class="invalid-feedback">
                                                    Por favor ingrese un email válido.
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-3">
                                                <label for="telefono">Teléfono</label>
                                                <input type="text" class="form-control" name="telefono" id="telefono"
                                                    required>
                                                <div class="invalid-feedback">
                                                    Por favor ingrese su número de teléfono.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 mb-3">
                                                <label for="padre_o_madre">Nombre de padre o madre (opcional)</label>
                                                <input type="text" class="form-control" name="padre_o_madre"
                                                    id="padre_o_madre">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 mb-3">
                                                <div class="card">
                                                    <p class="text-center bold">PRODUCTO O SERVICIO</p>
                                                    <div class="row text-center">
                                                        <div class="col-lg-6">
                                                            <div class="form-check"
                                                                style="display: flex; align-items: center; justify-content: center;">
                                                                <input name="producto" type="hidden" value="0">
                                                                <input id="producto_checkbox"
                                                                    onclick="document.getElementById('servicio_checkbox').checked = false;"
                                                                    type="checkbox" class="form-check-input"
                                                                    value="1" name="producto"
                                                                    style="margin-right: 5px;">
                                                                <label class="form-check-label"
                                                                    for="producto">Producto</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <div class="form-check"
                                                                style="display: flex; align-items: center; justify-content: center;">
                                                                <input name="servicio" type="hidden" value="0">
                                                                <input id="servicio_checkbox"
                                                                    onclick="document.getElementById('producto_checkbox').checked = false;"
                                                                    type="checkbox" class="form-check-input"
                                                                    value="1" name="servicio"
                                                                    style="margin-right: 5px;">
                                                                <label class="form-check-label"
                                                                    for="servicio">Servicio</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="card">
                                                    <p class="text-center bold">RECLAMO O QUEJA</p>
                                                    <div class="row text-center">
                                                        <div class="col-lg-6">
                                                            <div class="form-check"
                                                                style="display: flex; align-items: center; justify-content: center;">
                                                                <input name="reclamo" type="hidden" value="0">
                                                                <input id="reclamo_checkbox"
                                                                    onclick="document.getElementById('queja_checkbox').checked = false;"
                                                                    type="checkbox" class="form-check-input"
                                                                    value="1" name="reclamo"
                                                                    style="margin-right: 5px;">
                                                                <label class="form-check-label"
                                                                    for="reclamo">Reclamo</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <div class="form-check"
                                                                style="display: flex; align-items: center; justify-content: center;">
                                                                <input name="queja" type="hidden" value="0">
                                                                <input id="queja_checkbox"
                                                                    onclick="document.getElementById('reclamo_checkbox').checked = false;"
                                                                    type="checkbox" class="form-check-input"
                                                                    value="1" name="queja"
                                                                    style="margin-right: 5px;">
                                                                <label class="form-check-label"
                                                                    for="queja">Queja</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 mb-3">
                                                <label for="detalle">Detalle</label>
                                                <textarea required="required" class="form-control" name="detalle" id="detalle"></textarea>
                                                <div class="invalid-feedback">
                                                    Por favor ingrese el detalle de su reclamo o queja.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <!-- Eliminar el código relacionado con reCAPTCHA -->
                                                <!-- <script src="https://www.recaptcha.net/recaptcha/api.js" async defer></script>
                                                                            <script>
                                                                                var invisibleRecaptchaSubmit = function() {
                                                                                    var closestForm = function(ele) {
                                                                                        var curEle = ele.parentNode;
                                                                                        while (curEle.nodeName !== 'FORM' && curEle.nodeName !== 'BODY') {
                                                                                            curEle = curEle.parentNode;
                                                                                        }
                                                                                        return curEle.nodeName === 'FORM' ? curEle : null
                                                                                    };

                                                                                    var eles = document.getElementsByClassName('g-recaptcha');
                                                                                    if (eles.length > 0) {
                                                                                        var form = closestForm(eles[0]);
                                                                                        if (form) {
                                                                                            form.submit();
                                                                                        }
                                                                                    }
                                                                                };
                                                                            </script>
                                                                            <div>
                                                                                <div class="grecaptcha-badge" data-style="bottomright"
                                                                                    style="width: 256px; height: 60px; display: block; transition: right 0.3s; position: fixed; bottom: 14px; right: -186px; box-shadow: gray 0px 0px 5px; border-radius: 2px; overflow: hidden;">
                                                                                    <div class="grecaptcha-logo"><iframe title="reCAPTCHA" width="256"
                                                                                            height="60" role="presentation" name="a-gprjgtl3cfax"
                                                                                            frameborder="0" scrolling="no"
                                                                                            sandbox="allow-forms allow-popups allow-same-origin allow-scripts allow-top-navigation allow-modals allow-popups-to-escape-sandbox allow-storage-access-by-user-activation"
                                                                                            src="https://www.recaptcha.net/recaptcha/api2/anchor?ar=1&amp;k=6LfFPX4UAAAAALIuUCwAjFaD4D9Ct22MY1nLBb52&amp;co=aHR0cHM6Ly9heXVkYS5sbGFtYS5wZTo0NDM.&amp;hl=es-419&amp;v=bUO1BXI8H9PgjAPSW9hwuSeI&amp;size=invisible&amp;cb=fhk8pn8jtdt5"></iframe>
                                                                                    </div>
                                                                                    <div class="grecaptcha-error"></div>
                                                                                    <textarea id="g-recaptcha-response" name="g-recaptcha-response" class="g-recaptcha-response"
                                                                                        style="width: 250px; height: 40px; border: 1px solid rgb(193, 193, 193); margin: 10px 25px; padding: 0px; resize: none; display: none;"></textarea>
                                                                                </div><iframe style="display: none;"></iframe>
                                                                            </div> -->
                                                <!-- Ajustar el botón de envío -->
                                                <button type="submit"
                                                    class="btn btn-warning btn-lg btn-block">Enviar</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End libro de reclamaciones -->
    </main>

@endsection

@push('styles')
@endpush

@push('scripts')
@endpush
