@extends('frontend.layouts.master')
@section('title', 'RASEMCORP || SALUD')
@section('meta-author', 'RASEMCORP')
@section('meta-image', asset('frontend/assets/img/rasemcorp-fav.png'))
@section('meta-url', url()->current())
@section('meta-type', 'website')
@section('meta-robots', 'index, follow')
@section('main-content')

    <main class="main">
        <!-- Hero Section -->
        <section id="hero" class="heroheader section dark-background">
            <div style="position: relative;">
                <div
                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.7); z-index: 1;">
                </div>
                <img src="{{ asset('frontend/assets/img/hero-bg.jpg') }}" alt="" data-aos="fade-in"
                    style="position: relative; z-index: 0;">
            </div>
        </section>
        <!-- /Hero Section -->
        <!-- Services Section -->
        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Servicios</h2>
                <p>Salud</p>
                <div class="service-item position-relative">
                    <h3>CENTROS DE HERMODIALISIS</h3>
                    <p
                        style="background-image: url({{ asset('frontend/assets/img/salud-background.jpg') }}); background-size: cover; background-position: justify; padding: 20px; color: #fff;">
                        Centros médicos Orientados a lograr una mejor calidad de vida de nuestros pacientes. Prestamos
                        especial atención a todos los detalles del desarrollo de nuestros centros especializados en el
                        cuidado de pacientes renales. <br>
                        Invertimos en infraestructura y tecnología. Somos los únicos
                        centros a nivel nacional con tecnología NEXADIA, la cual nos permite una mejor evaluación del
                        paciente, así como la conectividad en tiempo real, con su hospital de referencia. </p>
                </div>
            </div><!-- End Section Title -->

            <div class="container">

                <div class="row gy-4">
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/clinical-care-logo.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('clinical-care') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Ut excepturi voluptatem nisi sed. Quidem fuga consequatur. Minus ea aut. Vel qui id voluptas
                                adipisci eos earum corrupti.</p> --}}
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/cedisan-logo.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('cedisan') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Provident nihil minus qui consequatur non omnis maiores. Eos accusantium minus dolores iure
                                perferendis tempore et consequatur.</p> --}}
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="600">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/kidney-logo.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('kidney-care') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Hic molestias ea quibusdam eos. Fugiat enim doloremque aut neque non et debitis iure.
                                Corrupti recusandae ducimus enim.</p> --}}
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/hemobalance-logo.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('hemobalance-care') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Non et temporibus minus omnis sed dolor esse consequatur. Cupiditate sed error ea fuga sit
                                provident adipisci neque.</p> --}}
                        </div>
                    </div><!-- End Service Item -->

                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="500">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/jrs-logo.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('jrs-meddev') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Cumque et suscipit saepe. Est maiores autem enim facilis ut aut ipsam corporis aut. Sed animi
                                at autem alias eius labore.</p> --}}
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/primelab.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('primelab') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Ut autem aut autem non a. Sint sint sit facilis nam iusto sint. Libero corrupti neque eum hic
                                non ut nesciunt dolorem.</p> --}}
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/intifarma-logo.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('intifarma') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Ut autem aut autem non a. Sint sint sit facilis nam iusto sint. Libero corrupti neque eum hic
                                non ut nesciunt dolorem.</p> --}}
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="{{ asset('frontend/assets/img/salud/pandorafarma-logo.png') }}" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="{{ route('pandorafarma') }}" class="stretched-link">
                                <h3></h3>
                            </a>
                            {{-- <p>Ut autem aut autem non a. Sint sint sit facilis nam iusto sint. Libero corrupti neque eum hic
                                non ut nesciunt dolorem.</p> --}}
                        </div>
                    </div><!-- End Service Item -->

                </div>

            </div>

        </section>
        <!-- /Services Section -->
    </main>

@endsection

@push('styles')
@endpush

@push('scripts')
@endpush
