<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\backend\AdminController;
use App\Http\Controllers\frontend\FrontendController;
use App\Http\Controllers\backend\PostCommentController;
use App\Http\Controllers\backend\MessageController;
use App\Http\Controllers\backend\UsersController;
use App\Http\Controllers\backend\BannerController;
use App\Http\Controllers\backend\PostCategoryController;
use App\Http\Controllers\backend\ServiceController;
use App\Http\Controllers\backend\PostTagController;
use App\Http\Controllers\backend\PostController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\HomeController;
use Laravel\Socialite\Facades\Socialite;
use App\Http\Controllers\Auth\LoginController;


// CACHE CLEAR ROUTE
Route::get('cache-clear', function () {
    Artisan::call('optimize:clear');
    session()->flash('success', 'Caché limpiada con éxito.');
    return redirect()->back();
})->name('cache.clear');
// STORAGE LINKED ROUTE
Route::get('storage-link', [AdminController::class, 'storageLink'])->name('storage.link');

Auth::routes(['register' => false]);
Route::get('user/login', [FrontendController::class, 'login'])->name('login.form');
Route::post('user/login', [FrontendController::class, 'loginSubmit'])->name('login.submit');
Route::get('user/logout', [FrontendController::class, 'logout'])->name('user.logout');

Route::get('user/register', [FrontendController::class, 'register'])->name('register.form');
Route::post('user/register', [FrontendController::class, 'registerSubmit'])->name('register.submit');
// Reset password
Route::post('password-reset', [FrontendController::class, 'showResetForm'])->name('password.reset');
// Socialite
Route::get('/auth/redirect/github', function () {
    return Socialite::driver('github')->redirect();
});
Route::get('/auth/callback/github', function () {
    $user = Socialite::driver('github')->user();
    // $user->token
});

Route::get('login/{provider}/', [LoginController::class, 'redirect'])->name('login.redirect');
Route::get('login/{provider}/callback/', [LoginController::class, 'Callback'])->name('login.callback');

// Frontend Routes
Route::get('/', [FrontendController::class, 'home']);
Route::get('/home', [FrontendController::class, 'home'])->name('home');
Route::get('/about-us', [FrontendController::class, 'aboutUs'])->name('about-us');
Route::get('/services', [FrontendController::class, 'services'])->name('services');
Route::get('/salud', [FrontendController::class, 'salud'])->name('salud');
Route::get('/clinical-care', [FrontendController::class, 'clinical_care'])->name('clinical-care');
Route::get('/cedisan', [FrontendController::class, 'cedisan'])->name('cedisan');
Route::get('/kidney-care', [FrontendController::class, 'kidney_care'])->name('kidney-care');
Route::get('/hemobalance-care', [FrontendController::class, 'hemobalance_care'])->name('hemobalance-care');
Route::get('/jrs-meddev', [FrontendController::class, 'jrs_meddev'])->name('jrs-meddev');
Route::get('/primelab', [FrontendController::class, 'primelab'])->name('primelab');
Route::get('/intifarma', [FrontendController::class, 'intifarma'])->name('intifarma');
Route::get('/pandorafarma', [FrontendController::class, 'pandorafarma'])->name('pandorafarma');
Route::get('/tsg-trade', [FrontendController::class, 'tsg_trade'])->name('tsg-trade');
Route::get('/ingenieria_construccion', [FrontendController::class, 'ingenieria_construccion'])->name('ingenieria_construccion');
Route::get('/libro-reclamaciones', [FrontendController::class, 'libroReclamaciones'])->name('libro-reclamaciones');
Route::post('/libro-reclamaciones', [FrontendController::class, 'libroReclamacionesSubmit'])->name('libro-reclamaciones.submit');
Route::get('/terms-and-conditions', [FrontendController::class, 'termsAndConditions'])->name('terms-and-conditions');
Route::get('/privacy-policy', [FrontendController::class, 'privacyPolicy'])->name('privacy-policy');
Route::get('/return-policy', [FrontendController::class, 'returnPolicy'])->name('return-policy');
Route::get('/shipping-policy', [FrontendController::class, 'shippingPolicy'])->name('shipping-policy');
Route::get('/faq', [FrontendController::class, 'faq'])->name('faq');
Route::get('/contact', [FrontendController::class, 'contact'])->name('contact');
Route::post('/contact/message', [MessageController::class, 'store'])->name('contact.store');
// Blog
Route::get('/blog', [FrontendController::class, 'blog'])->name('blog');
Route::get('/blog-detail/{slug}', [FrontendController::class, 'blogDetail'])->name('blog.detail');
Route::get('/blog/search', [FrontendController::class, 'blogSearch'])->name('blog.search');
Route::post('/blog/filter', [FrontendController::class, 'blogFilter'])->name('blog.filter');
Route::get('blog-cat/{slug}', [FrontendController::class, 'blogByCategory'])->name('blog.category');
Route::get('blog-tag/{slug}', [FrontendController::class, 'blogByTag'])->name('blog.tag');
// NewsLetter
Route::post('/subscribe', [FrontendController::class, 'subscribe'])->name('subscribe');
// Post Comment
Route::post('post/{slug}/comment', [PostCommentController::class, 'store'])->name('post-comment.store');
Route::resource('post-comments', PostCommentController::class);
// Backend section start

Route::group(['prefix' => '/admin', 'middleware' => ['auth', 'admin']], function () {
    Route::get('/', [AdminController::class, 'index'])->name('admin');
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin-dashboard');
    // user route
    Route::resource('users', UsersController::class);
    // Banner
    Route::resource('banner', BannerController::class);
    //service
    Route::resource('service', ServiceController::class);
    // POST category
    Route::resource('/post-category', PostCategoryController::class);
    // Post tag
    Route::resource('/post-tag', PostTagController::class);
    // Post
    Route::resource('/post', PostController::class);
    // Message
    Route::resource('/message', MessageController::class);
    Route::get('/message/five', [MessageController::class, 'messageFive'])->name('messages.five');
    // Profile
    Route::get('/profile', [AdminController::class, 'profile'])->name('admin-profile');
    Route::post('/profile/{id}', [AdminController::class, 'profileUpdate'])->name('profile-update');
    // Settings
    Route::get('settings', [AdminController::class, 'settings'])->name('settings');
    Route::post('setting/update', [AdminController::class, 'settingsUpdate'])->name('settings.update');
    // Password Change
    Route::get('change.password', [AdminController::class, 'changePassword'])->name('change.passwordadmin.form');
    Route::post('change.password', [AdminController::class, 'changPasswordStore'])->name('change.passwordadmin');
});

// User section start
Route::group(['prefix' => '/user', 'middleware' => ['user']], function () {
    Route::get('/', [HomeController::class, 'index'])->name('user');
    // Profile
    Route::get('/profile', [HomeController::class, 'profile'])->name('user-profile');
    Route::post('/profile/{id}', [HomeController::class, 'profileUpdate'])->name('user-profile-update');
    // Product Review
    Route::get('/user-review', [HomeController::class, 'productReviewIndex'])->name('user.productreview.index');
    Route::delete('/user-review/delete/{id}', [HomeController::class, 'productReviewDelete'])->name('user.productreview.delete');
    Route::get('/user-review/edit/{id}', [HomeController::class, 'productReviewEdit'])->name('user.productreview.edit');
    Route::patch('/user-review/update/{id}', [HomeController::class, 'productReviewUpdate'])->name('user.productreview.update');
    // Post comment
    Route::get('user-post/comment', [HomeController::class, 'userComment'])->name('user.post-comment.index');
    Route::delete('user-post/comment/delete/{id}', [HomeController::class, 'userCommentDelete'])->name('user.post-comment.delete');
    Route::get('user-post/comment/edit/{id}', [HomeController::class, 'userCommentEdit'])->name('user.post-comment.edit');
    Route::patch('user-post/comment/udpate/{id}', [HomeController::class, 'userCommentUpdate'])->name('user.post-comment.update');
    // Password Change
    Route::get('change-password', [HomeController::class, 'changePassword'])->name('user.change.password.form');
    Route::post('change-password', [HomeController::class, 'changPasswordStore'])->name('change.password');
});
