<?php $__env->startSection('title', 'RASEMCORP || HOME PAGE'); ?>
<?php $__env->startSection('meta-image', asset('frontend/assets/img/rasemcorp-fav.png')); ?>
<?php $__env->startSection('meta-url', url()->current()); ?>
<?php $__env->startSection('meta-type', 'website'); ?>
<?php $__env->startSection('meta-robots', 'index, follow'); ?>
<?php $__env->startSection('main-content'); ?>
    <!-- Slider Area -->
    

    <main class="main">

        <!-- Hero Section -->
        <section id="hero" class="hero section dark-background">

            <img src="<?php echo e(asset('frontend/assets/img/hero-bg.jpg')); ?>" alt="" data-aos="fade-in">

            <div class="container">

                <div class="row justify-content-center text-center" data-aos="fade-up" data-aos-delay="100">
                    <div class="col-xl-6 col-lg-8">
                        <h2>Somos un grupo de empresas <span>.</span></h2>
                        <p>orientada a lograr una mejor calidad de vida para nuestros clientes.</p>
                    </div>
                </div>

                <div class="row gy-4 mt-5 justify-content-center" data-aos="fade-up" data-aos-delay="200">
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="300">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('clinical-care')); ?>">CLINICAL CARE</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="400">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('cedisan')); ?>">CEDISAN</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="500">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('kidney-care')); ?>">KIDNEY CARE</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="600">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('hemobalance-care')); ?>">HEMOBALANCE CARE</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="800">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('jrs-meddev')); ?>">JRS MEDDEV</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="700">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('primelab')); ?>">PRIMELAB</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="800">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('intifarma')); ?>">INTIFARMA</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="800">
                        <div class="icon-box">
                            <i class="bi bi-fullscreen-exit"></i>
                            <h3><a href="<?php echo e(route('pandorafarma')); ?>">PANDORAFARMA</a></h3>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-4" data-aos="fade-up" data-aos-delay="800">
                        <div class="icon-box">
                            <i class="bi bi-binoculars"></i>
                            <h3><a href="<?php echo e(route('tsg-trade')); ?>">TSG TRADE</a></h3>
                        </div>
                    </div>
                </div>

            </div>

        </section><!-- /Hero Section -->

        <!-- About Section -->
        <section id="about" class="about section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="row gy-4">
                    <div class="col-lg-6 order-1 order-lg-2">
                        <img src="<?php echo e(asset('frontend/assets/img/text-header.png')); ?>" class="img-fluid" alt="">
                    </div>
                    <div class="col-lg-6 order-2 order-lg-1 content">
                        <h3>¿Quienes somos?</h3>
                        <p class="fst-italic">
                            Somos un grupo empresarial integrado por un equipo de profesionales que gestionamos y
                            desarrollamos nuestras actividades en distintas áreas de acción y líneas de negocio, siempre
                            manteniendo los más altos valores de calidad.
                        </p>
                        <ul>
                            <li><i class="bi bi-check2-all"></i> <span>Nuestra Historia</span></li>
                            <?php
                                $date1 = '1998';
                                $date2 = date('Y');
                                $diff = $date2 - $date1;
                            ?>
                            <p>
                                El grupo surge como empresa familiar, hace <?php echo e($diff); ?> años, con una visión de
                                aportar al crecimiento
                                y desarrollo de nuestro país y nuestra gente. en 1998, se construye, equipa y gestiona
                                nuestro primer centro de hemodiálisis, en la ciudad de lima, constituyendo al día de hoy
                                como unos de los principales proveedores del servicio de atención ambulatoria para pacientes
                                con enfermedad renal crónica en el Perú.
                            </p>
                            <li><i class="bi bi-check2-all"></i> <span>Nuestro Personal</span></li>
                            <p>
                                Contamos con un grupo humano comprometido y responsable por el logro de los objetivos al
                                asumir nuevos retos en los diferentes proyectos a desarrollar y ejecutar. Damos empleo a más
                                de 250 personas en planilla fija, además del personal rotativo según proyecto a ejecutar.
                            </p>
                        </ul>
                    </div>
                </div>
            </div>

        </section><!-- /About Section -->

        <!-- Clients Section -->
        <section id="clients" class="clients section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="swiper init-swiper">
                    <script type="application/json" class="swiper-config">
                {
                  "loop": true,
                  "speed": 600,
                  "autoplay": {
                    "delay": 5000
                  },
                  "slidesPerView": "auto",
                  "pagination": {
                    "el": ".swiper-pagination",
                    "type": "bullets",
                    "clickable": true
                  },
                  "breakpoints": {
                    "320": {
                      "slidesPerView": 2,
                      "spaceBetween": 40
                    },
                    "480": {
                      "slidesPerView": 3,
                      "spaceBetween": 60
                    },
                    "640": {
                      "slidesPerView": 4,
                      "spaceBetween": 80
                    },
                    "992": {
                      "slidesPerView": 6,
                      "spaceBetween": 120
                    }
                  }
                }
              </script>
                    <div class="swiper-wrapper align-items-center">
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('clinical-care')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/clinical-care-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('cedisan')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/cedisan-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('kidney-care')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/kidney-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('hemobalance-care')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/hemobalance-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('jrs-meddev')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/jrs-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('primelab')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/primelab.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('intifarma')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/intifarma-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('pandorafarma')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/pandorafarma-logo.png')); ?>"
                                    class="img-fluid" alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('tsg-trade')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/ingenieria/tsg-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>

            </div>

        </section><!-- /Clients Section -->

        <!-- Features Section -->
        <section id="features" class="features section">

            <div class="container">

                <div class="row gy-4">
                    <!-- Section Title -->
                    <div class="container section-title" data-aos="fade-up">
                        <h2>Quienes Somos</h2>
                        <p>Organigrama</p>
                    </div><!-- End Section Title -->
                    <div class="features-image col-lg-6" data-aos="fade-up" data-aos-delay="100">

                        <img src="<?php echo e(asset('frontend/assets/img/organigrama.png')); ?>" alt="" class="img-fluid"
                            style="width: 100%; height: auto; object-fit: cover;">
                    </div>
                    <div class="col-lg-6">

                        <div class="features-item d-flex ps-0 ps-lg-3 pt-4 pt-lg-0" data-aos="fade-up"
                            data-aos-delay="200">
                            <i class="bi bi-broadcast flex-shrink-0"></i>
                            <div>
                                <h4>Objetivos</h4>
                                <p>La satisfacción y cumplimiento con los requerimientos y necesidades de nuestros clientes,
                                    al prestar nuestros servicios de calidad, manteniendo el control y mejorando nuestros
                                    procesos de la organización basado en una mejora continua.</p>
                            </div>
                        </div><!-- End Features Item-->

                        <div class="features-item d-flex mt-5 ps-0 ps-lg-3" data-aos="fade-up" data-aos-delay="300">
                            <i class="bi bi-broadcast flex-shrink-0"></i>
                            <div>
                                <h4>Mision</h4>
                                <p>Proporcionar a nuestros clientes asesoría, servicios, ingeniería y ejecución de proyectos
                                    de calidad usando la mejor tecnología de diseño, materiales y equipamiento, bajo la
                                    dirección de nuestro personal altamente calificado.</p>
                            </div>
                        </div><!-- End Features Item-->

                        <div class="features-item d-flex mt-5 ps-0 ps-lg-3" data-aos="fade-up" data-aos-delay="400">
                            <i class="bi bi-broadcast flex-shrink-0"></i>
                            <div>
                                <h4>Vision</h4>
                                <p>Posicionarnos en el ámbito privado y estatal a nivel nacional como una de las mejores
                                    empresas y mantenernos a la vanguardia en cuanto a las nuevas tecnologías de la
                                    construcción, gestión de la salud, basándonos en la especialización de la nuestros
                                    personal.</p>
                            </div>
                        </div><!-- End Features Item-->

                    </div>
                </div>

            </div>

        </section><!-- /Features Section -->

        <!-- Services Section -->
        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Servicios</h2>
                <p>Salud</p>
                <div class="service-item position-relative">
                    <h3>CENTROS DE HERMODIALISIS</h3>
                    <p
                        style="background-image: url(<?php echo e(asset('frontend/assets/img/salud-background.jpg')); ?>); background-size: cover; background-position: justify; padding: 20px; color: #fff;">
                        Centros médicos Orientados a lograr una mejor calidad de vida de nuestros pacientes. Prestamos
                        especial atención a todos los detalles del desarrollo de nuestros centros especializados en el
                        cuidado de pacientes renales. <br>
                        Invertimos en infraestructura y tecnología. Somos los únicos
                        centros a nivel nacional con tecnología NEXADIA, la cual nos permite una mejor evaluación del
                        paciente, así como la conectividad en tiempo real, con su hospital de referencia. </p>
                </div>
            </div><!-- End Section Title -->

            <div class="container">

                <div class="row gy-4">
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/clinical-care-logo.png')); ?>"
                                    class="img-fluid" alt="">
                            </div>
                            <a href="<?php echo e(route('clinical-care')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="100">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/cedisan-logo.png')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="<?php echo e(route('cedisan')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="600">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/kidney-logo.png')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="<?php echo e(route('kidney-care')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/hemobalance-logo.png')); ?>"
                                    class="img-fluid" alt="">
                            </div>
                            <a href="<?php echo e(route('hemobalance-care')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->

                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="500">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/jrs-logo.png')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="<?php echo e(route('jrs-meddev')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/primelab.png')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="<?php echo e(route('primelab')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/intifarma-logo.png')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="<?php echo e(route('intifarma')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/pandorafarma-logo.png')); ?>"
                                    class="img-fluid" alt="">
                            </div>
                            <a href="<?php echo e(route('pandorafarma')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->

                </div>

            </div>

        </section>
        <!-- /Services Section -->

        <!-- Call To Action Section -->
        <section id="call-to-action" class="call-to-action section dark-background">

            <img src="<?php echo e(asset('frontend/assets/img/cta-bg.jpg')); ?>" alt="">

            <div class="container">
                <div class="row justify-content-center" data-aos="zoom-in" data-aos-delay="100">
                    <div class="col-xl-10">
                        <div class="text-center">
                            <h3>RESPONSABILIDAD, OPTIMISMO, LEALTAD, VALORES, CALIDAD, PUNTUALIDAD, INTEGRIDAD, CUMPLIMIENTO
                            </h3>
                            <p>Son nuestras mejores armas para lograr el éxito en cada uno de nuestros proyectos.</p>
                            </p>
                            <a class="cta-btn" href="<?php echo e(route('contact')); ?>">CONTACTANOS</a>
                        </div>
                    </div>
                </div>
            </div>

        </section><!-- /Call To Action Section -->
        
        <!-- Services Section -->
        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Servicios</h2>
                <p>INGENIERIA</p>
                <div class="service-item position-relative">
                    <h3>INGENIERIA, CONSTRUCCION Y PROCURA</h3>
                    <p
                        style="background-image: url(<?php echo e(asset('frontend/assets/img/ingenieria-background.jpg')); ?>); background-size: cover; background-position: justify; padding: 20px; color: #fff;">
                        Integramos los estándares de calidad con los requerimientos de prevención de riesgo necesarios
                        durante la construcción, así como el cuidado y buen manejo del medio ambiente con su entorno. <br>
                        Contamos con un gran equipo de profesionales especializados en cada una de las actividades que
                        incursionamos garantizando una atención inmediata.
                    </p>
                </div>
            </div><!-- End Section Title -->

            <div class="container">

                <div class="row gy-4">
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="300">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/ingenieria/tsg-trade.png')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="<?php echo e(route('tsg-trade')); ?>" class="stretched-link">
                                <h3></h3>
                            </a>
                            <p style="text-align: justify;">Contamos con un staff calificado de profesionales que brindan servicios de mantenimiento de
                                equipos biomédicos y servicios generales para nuestros centros de hemodiálisis. <br>
                                Asimismo, damos atención a clientes públicos como los principales hospitales del país.
                            </p>
                        </div>
                    </div><!-- End Service Item -->

                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                        <div class="service-item position-relative">
                            <div class="icon">
                                <img src="<?php echo e(asset('frontend/assets/img/metrotech/ingenieria-logo.png')); ?>"
                                    class="img-fluid" alt="">
                            </div>
                            <a href="<?php echo e(route('tsg-trade')); ?>" class="stretched-link">
                                <h3>INGENIERIA</h3>
                            </a>
                            <p>
                            <ul style="text-align: left;">
                                <li>Desarrollo de Proyecto</li>
                                <li>Diseño y elaboración de planos arquitectonicos</li>
                                <li>Diseño y elaboración de planos de estructura</li>
                                <li>Instalaciones electricas, sanitarias e instalaciones especiales</li>
                            </ul>
                            </p>
                            <a href="<?php echo e(route('tsg-trade')); ?>" class="stretched-link"></a>
                        </div>
                    </div><!-- End Service Item -->

                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="500">
                        <div class="service-item position-relative">
                            <div class="icon">
                                <img src="<?php echo e(asset('frontend/assets/img/metrotech/construccion-logo.png')); ?>"
                                    class="img-fluid" alt="">
                            </div>
                            <a href="<?php echo e(route('tsg-trade')); ?>" class="stretched-link">
                                <h3>CONSTRUCCIÓN</h3>
                            </a>
                            <p>
                            <ul style="text-align: left;">
                                <li>Edificaciones(sector vivienda)</li>
                                <li>Industriales(sector industrial)</li>
                                <li>Vitales(sector transporte)</li>
                                <li>Mineria(sector mineria)</li>
                                <li>Energia(sector energia)</li>
                            </ul>
                            </p>
                            <a href="<?php echo e(route('tsg-trade')); ?>" class="stretched-link"></a>
                        </div>
                    </div><!-- End Service Item -->

                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="600">
                        <div class="service-item position-relative">
                            <div class="icon">
                                <img src="<?php echo e(asset('frontend/assets/img/metrotech/procura-logo.png')); ?>"
                                    class="img-fluid" alt="">
                            </div>
                            <a href="<?php echo e(route('tsg-trade')); ?>" class="stretched-link">
                                <h3>PROCURA</h3>
                            </a>
                            <p>
                            <ul style="text-align: left;">
                                <li>Implementación de un sistema logístico integral de acuerdo a la necesidad de cada
                                    proyecto</li>
                            </ul>
                            </p>
                            <a href="<?php echo e(route('tsg-trade')); ?>" class="stretched-link"></a>
                        </div>
                    </div><!-- End Service Item -->

                </div>

            </div>

        </section>
        <!-- /Services Section -->
        <!-- Portfolio Section -->
        <section id="portfolio" class="portfolio section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Experiencia</h2>
                <p>Experiencia en el mercado</p>
            </div><!-- End Section Title -->

            <div class="container">

                <div class="isotope-layout" data-default-filter="*" data-layout="masonry" data-sort="original-order">

                    <ul class="portfolio-filters isotope-filters" data-aos="fade-up" data-aos-delay="100">
                        <li data-filter="*" class="filter-active">Desde 1998 contigo</li>
                        
                    </ul><!-- End Portfolio Filters -->

                    <div class="row gy-4 isotope-container" data-aos="fade-up" data-aos-delay="200">

                        <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-app">
                            <img src="<?php echo e(asset('frontend/assets/img/masonry-portfolio/exp-mercado-table.png')); ?>"
                                class="img-fluid" alt="">
                            <div class="portfolio-info">
                                <h4>Experiencia</h4>
                                <p>Trayectoria</p>
                                <a href="<?php echo e(asset('frontend/assets/img/masonry-portfolio/exp-mercado-table.png')); ?>"
                                    title="Trayectoria" data-gallery="portfolio-gallery-app"
                                    class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                                
                            </div>
                        </div><!-- End Portfolio Item -->

                        <div class="col-lg-4 col-md-6 portfolio-item isotope-item filter-product">
                            <img src="<?php echo e(asset('frontend/assets/img/masonry-portfolio/exp-mercado-img.png')); ?>"
                                class="img-fluid" alt="">
                            <div class="portfolio-info">
                                <h4>Experincia</h4>
                                <p>Trayectoria</p>
                                <a href="<?php echo e(asset('frontend/assets/img/masonry-portfolio/exp-mercado-img.png')); ?>"
                                    title="Experiencia" data-gallery="portfolio-gallery-product"
                                    class="glightbox preview-link"><i class="bi bi-zoom-in"></i></a>
                                
                            </div>
                        </div><!-- End Portfolio Item -->

                    </div><!-- End Portfolio Container -->

                </div>

            </div>

        </section><!-- /Portfolio Section -->

        <!-- Stats Section -->
        <section id="stats" class="stats section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="row gy-4 align-items-center justify-content-between">

                    <div class="col-lg-5">
                        <img src="<?php echo e(asset('frontend/assets/img/text-header.png')); ?>" alt="" class="img-fluid">
                    </div>

                    <div class="col-lg-6">

                        <h3 class="fw-bold fs-2 mb-3">Más de 750 000</h3>
                        <p>
                            Sesiones de Hemodiálisis entregadas, satisfactoriamente y más de 2 500 000 de horas
                            asistenciales en la atención de nuestros pacientes.
                        </p>

                        <div class="row gy-4">

                            <div class="col-lg-6">
                                <div class="stats-item d-flex">
                                    <i class="bi bi-emoji-smile flex-shrink-0"></i>
                                    <div>
                                        <span data-purecounter-start="0" data-purecounter-end="750000"
                                            data-purecounter-duration="1" class="purecounter"></span>
                                        <p><strong>Clientes satisfechos</strong> <span> por nuestros servicios</span></p>
                                    </div>
                                </div>
                            </div><!-- End Stats Item -->

                            

                            <div class="col-lg-6">
                                <div class="stats-item d-flex">
                                    <i class="bi bi-headset flex-shrink-0"></i>
                                    <div>
                                        <span data-purecounter-start="0" data-purecounter-end="2500000"
                                            data-purecounter-duration="1" class="purecounter"></span>
                                        <p><strong>Horas de asistencia</strong> <span>a nuestros pacientes</span></p>
                                    </div>
                                </div>
                            </div><!-- End Stats Item -->

                            <div class="col-lg-6">
                                <div class="stats-item d-flex">
                                    <i class="bi bi-people flex-shrink-0"></i>
                                    <div>
                                        <span data-purecounter-start="0" data-purecounter-end="250"
                                            data-purecounter-duration="1" class="purecounter"></span>
                                        <p><strong>Colaboradores</strong> <span> que forman parte de nuestra familia</span>
                                        </p>
                                    </div>
                                </div>
                            </div><!-- End Stats Item -->

                        </div>

                    </div>

                </div>

            </div>

        </section><!-- /Stats Section -->

        <!-- Testimonials Section -->
        <section id="testimonials" class="testimonials section dark-background">

            <img src="<?php echo e(asset('frontend/assets/img/testimonials-bg.jpg')); ?>" class="testimonials-bg" alt="">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="swiper init-swiper">
                    <script type="application/json" class="swiper-config">
                {
                  "loop": true,
                  "speed": 600,
                  "autoplay": {
                    "delay": 5000
                  },
                  "slidesPerView": "auto",
                  "pagination": {
                    "el": ".swiper-pagination",
                    "type": "bullets",
                    "clickable": true
                  }
                }
              </script>
                    <div class="swiper-wrapper">

                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <img src="<?php echo e(asset('frontend/assets/img/team/jose_ravanal.png')); ?>"
                                    class="testimonial-img" alt="">
                                <h3>Jose Carlos Rabanal seminario</h3>
                                <h4>Gerente General</h4>
                                
                                
                            </div>
                        </div>
                        <!-- End testimonial item -->

                        
                        <!-- End testimonial item -->

                        
                        <!-- End testimonial item -->

                        
                        <!-- End testimonial item -->

                        

                    </div>
                    <div class="swiper-pagination"></div>
                </div>

            </div>

        </section><!-- /Testimonials Section -->

        <!-- Team Section -->
        
        <!-- /Team Section -->

        <!-- Contact Section -->
        <section id="contact" class="contact section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Contacto</h2>
                <p>Visitanos en nuestras oficinas</p>
            </div><!-- End Section Title -->

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="mb-4" data-aos="fade-up" data-aos-delay="200">
                    <iframe style="border:0; width: 100%; height: 270px;"
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4627.655826598832!2d-77.03754082418436!3d-12.094960642801583!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x9105c85d12e190e7%3A0x64bed3df9a586015!2sOficina%20501%2C%20Av.%20Camino%20Real%20159%2C%20San%20Isidro%2015073!5e1!3m2!1ses!2spe!4v1744174292244!5m2!1ses!2spe"
                        frameborder="0" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>

                </div><!-- End Google Maps -->

                <div class="row gy-4">
                    <?php
                        $data = DB::table('settings')->first();
                    ?>
                    <div class="col-lg-4">
                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="300">
                            <i class="bi bi-geo-alt flex-shrink-0"></i>
                            <div>
                                <h3>DIRECCIÓN</h3>
                                <?php if(!empty($data->address)): ?>
                                    <p>

                                        <?php echo e($data->address); ?>


                                    </p>
                                <?php endif; ?>
                            </div>
                        </div><!-- End Info Item -->

                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="400">
                            <i class="bi bi-telephone flex-shrink-0"></i>
                            <div>
                                <h3>Llámanos</h3>
                                <?php if(!empty($data->phone)): ?>
                                    <p class="mt-3"><strong>Phone:</strong> <span>

                                            <a href="tel:<?php echo e($data->phone); ?>"> <?php echo e($data->phone); ?> </a>

                                        </span></p>
                                <?php endif; ?>
                            </div>
                        </div><!-- End Info Item -->

                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="500">
                            <i class="bi bi-envelope flex-shrink-0"></i>
                            <div>
                                <h3>Email</h3>
                                <?php if(!empty($data->email)): ?>
                                    <p><strong>Email:</strong> <span>

                                            <a href="mailto:<?php echo e($data->email); ?>"><?php echo e($data->email); ?></a> <br>
                                            <a href="mailto:jose.rabanal@rasemcorp.com">jose.rabanal@rasemcorp.com</a>

                                        </span></p>
                                <?php endif; ?>
                            </div>
                        </div><!-- End Info Item -->

                    </div>

                    <div class="col-lg-8">
                        <form action="frontend/forms/contact.php" method="post" class="php-email-form"
                            data-aos="fade-up" data-aos-delay="200">
                            <div class="row gy-4">

                                <div class="col-md-6">
                                    <input type="text" name="name" class="form-control" placeholder="Su nombre"
                                        required="">
                                </div>

                                <div class="col-md-6 ">
                                    <input type="email" class="form-control" name="email" placeholder="Su Email"
                                        required="">
                                </div>

                                <div class="col-md-12">
                                    <input type="text" class="form-control" name="subject" placeholder="Asunto"
                                        required="">
                                </div>

                                <div class="col-md-12">
                                    <textarea class="form-control" name="message" rows="6" placeholder="Mensaje" required=""></textarea>
                                </div>

                                <div class="col-md-12 text-center">
                                    <div class="loading">Loading</div>
                                    <div class="error-message"></div>
                                    <div class="sent-message">Tu mensaje ha sido enviado. ¡Gracias!</div>

                                    <button type="submit">Enviar Mensaje</button>
                                </div>

                            </div>
                        </form>
                    </div><!-- End Contact Form -->

                </div>

            </div>

        </section>
        <!-- /Contact Section -->

    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\rasemcorp_web\resources\views/frontend/index.blade.php ENDPATH**/ ?>