<?php $__env->startSection('title', 'RASEMCORP || CONTACTO'); ?>
<?php $__env->startSection('meta-author', 'RASEMCORP'); ?>
<?php $__env->startSection('meta-image', asset('frontend/assets/img/rasemcorp-fav.png')); ?>
<?php $__env->startSection('meta-url', url()->current()); ?>
<?php $__env->startSection('meta-type', 'website'); ?>
<?php $__env->startSection('meta-robots', 'index, follow'); ?>
<?php $__env->startSection('main-content'); ?>

    <main class="main">
        <!-- Hero Section -->
        <section id="hero" class="heroheader section dark-background">
            <div style="position: relative;">
                <div
                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.7); z-index: 1;">
                </div>
                <img src="<?php echo e(asset('frontend/assets/img/hero-bg.jpg')); ?>" alt="" data-aos="fade-in"
                    style="position: relative; z-index: 0;">
            </div>
        </section>
        <!-- /Hero Section -->
        <!-- Contact Section -->
        <section id="contact" class="contact section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Contacto</h2>
                <p>Visitanos en nuestras oficinas</p>
            </div><!-- End Section Title -->

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="mb-4" data-aos="fade-up" data-aos-delay="200">
                    <iframe style="border:0; width: 100%; height: 270px;"
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4622.573388666623!2d-77.041079924239!3d-12.095115888145456!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x9105c9bf4b4cb5a1%3A0x404b992731cc9ac5!2sRASEMCORP%20SAC!5e1!3m2!1ses-419!2spe!4v1743098869204!5m2!1ses-419!2spe"
                        frameborder="0" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>

                </div><!-- End Google Maps -->

                <div class="row gy-4">
                    <?php
                        $data = DB::table('settings')->first();
                    ?>
                    <div class="col-lg-4">
                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="300">
                            <i class="bi bi-geo-alt flex-shrink-0"></i>
                            <div>
                                <h3>DIRECCIÓN</h3>
                                <?php if(!empty($data->address)): ?>
                                    <p>

                                        <?php echo e($data->address); ?>


                                    </p>
                                <?php endif; ?>
                            </div>
                        </div><!-- End Info Item -->

                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="400">
                            <i class="bi bi-telephone flex-shrink-0"></i>
                            <div>
                                <h3>Llámanos</h3>
                                <?php if(!empty($data->phone)): ?>
                                    <p class="mt-3"><strong>Phone:</strong> <span>

                                            <a href="tel:<?php echo e($data->phone); ?>"> <?php echo e($data->phone); ?> </a>

                                        </span></p>
                                <?php endif; ?>
                            </div>
                        </div><!-- End Info Item -->

                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="500">
                            <i class="bi bi-envelope flex-shrink-0"></i>
                            <div>
                                <h3>Email</h3>
                                <?php if(!empty($data->email)): ?>
                                    <p><strong>Email:</strong> <span>

                                            <a href="mailto:<?php echo e($data->email); ?>"><?php echo e($data->email); ?></a>

                                        </span></p>
                                <?php endif; ?>
                            </div>
                        </div><!-- End Info Item -->

                    </div>

                    <div class="col-lg-8">
                        <form action="frontend/forms/contact.php" method="post" class="php-email-form" data-aos="fade-up"
                            data-aos-delay="200">
                            <div class="row gy-4">

                                <div class="col-md-6">
                                    <input type="text" name="name" class="form-control" placeholder="Su nombre"
                                        required="">
                                </div>

                                <div class="col-md-6 ">
                                    <input type="email" class="form-control" name="email" placeholder="Su Email"
                                        required="">
                                </div>

                                <div class="col-md-12">
                                    <input type="text" class="form-control" name="subject" placeholder="Asunto"
                                        required="">
                                </div>

                                <div class="col-md-12">
                                    <textarea class="form-control" name="message" rows="6" placeholder="Mensaje" required=""></textarea>
                                </div>

                                <div class="col-md-12 text-center">
                                    <div class="loading">Loading</div>
                                    <div class="error-message"></div>
                                    <div class="sent-message">Tu mensaje ha sido enviado. ¡Gracias!</div>

                                    <button type="submit">Enviar Mensaje</button>
                                </div>

                            </div>
                        </form>
                    </div><!-- End Contact Form -->

                </div>

            </div>

        </section>
        <!-- /Contact Section -->
    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\rasemcorp_web\resources\views/frontend/pages/contact.blade.php ENDPATH**/ ?>